﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
var winExportRequestMode = 0,
    currRequestID,
    currMyRequestIndex,
    newMyRequestIndex,
    orgExportRequestName = '',
    bLoadingRequest = false,
    strContinueChange = '',
    orgRequest = '',
    newRequest = '';

//====================================================================================================================
//== Export Request Window - BEGIN
//====================================================================================================================
//Validate form
var fnSTATValForm = function () {
    if (App.tfRequestName.isValid() && App.dfFromDate.isValid() && App.dfToDate.isValid()) {
        App.btnSubmitReport.setDisabled(false);
    } else {
        App.btnSubmitReport.setDisabled(true);
    }
};

var fnValidateExportRequestWindow = function () {
    if (winExportRequestMode == 0 || //New
        winExportRequestMode == 2) { //Save As
        App.btnExportRequestSave.setDisabled(!App.txtExportRequestName.isValid());
    }
    else {
        if (App.txtExportRequestName.isValid()) {
            if (App.txtExportRequestName.getValue() == orgExportRequestName) {
                App.btnExportRequestSave.setDisabled(true);
            }
            else {
                App.btnExportRequestSave.setDisabled(false);
            }
        }
    }
};

//Save from the popup window
var fnSaveExportRequest = function () {
    if (winExportRequestMode == 0) { //New
        App.direct.REPSSTAT.OnCreateExportRequest({
            success: function (result) {
                fnDisableRequestSelection();
            }
        });
    }
    else if (winExportRequestMode == 1) { //Update
        App.direct.REPSSTAT.OnRenameExportRequest(currRequestID, {
            success: function () {
                fnDisableRequestSelection();
            }
        });
    }
    else if (winExportRequestMode == 2) { //Save As
        var strDF = '',
            n = 0;

        //get DataFields selected...
        n = App.tDataFields.getChecked().length;
        for (i = 0; i < n; i++) {
            strDF += App.tDataFields.getChecked()[i].raw.field;
            if (i < n - 1) {
                strDF += ',';
            }
        }

        App.direct.REPSSTAT.OnSaveAsExportRequest(strDF, {
            success: function () {
                fnDisableRequestSelection();
            }
        });
    }
};

var fnDisableRequestSelection = function () {
    //App.pnlFilters.setDisabled(true);
    //App.pnlDataSelection.setDisabled(true);

    App.tfRequestName.setValue('');

    fnClearFilters();
    fnClearDataFields();
};

var fnClearFilters = function () {
    App.dfFromDate.clear();
    App.dfFromDate.clearInvalid();

    App.dfToDate.clear();
    App.dfToDate.clearInvalid();

    bLoadingRequest = true;
    App.cboFilterRegion.clear();
    bLoadingRequest = false;

    App.cboFilterSite.clear();

    App.cboFilterProgram.clear();

    App.chkInpatient.clear();
    App.chkOutpatient.clear();

};

var fnClearDataFields = function () {
    App.tDataFields.clearChecked();
};

var fnClearInvalid = function () {
    App.dfFromDate.clearInvalid();
    App.dfToDate.clearInvalid();
};
//====================================================================================================================
//== Export Request Window - END
//====================================================================================================================

//====================================================================================================================
//== MyRequest ToolBar - BEGIN
//====================================================================================================================
//btnNewRequest - NEW
var fnOnShowCreateExportRequestWindow = function () {
    if (!fnCheckRequestChanges(fnHandlerAnswerNewRequest)) {
        showNewWindow();
    }
};

//btnSaveRequest - Save from the MyRequest list
var fnOnSaveExportRequest = function () {
    var request_id = 0,
        strDF = '';

    //get current request...
    request_id = App.gpMyRequest.getSelectionModel().getSelection()[0].raw.REQUEST_ID;

    //get DataFields selected...
    strDF = fnGetDataFieldString();

    //save/update...
    App.direct.REPSSTAT.OnUpdateExportRequest(request_id, strDF, true);

};

//btnSaveAsRequest - Save As
var fnOnShowSaveAsExportRequestWindow = function () {
    showSaveAsWindow(App.gpMyRequest.getSelectionModel().getSelection()[0].raw.REQUEST_ID);
};

var showNewWindow = function () {
    winExportRequestMode = 0; //New

    App.winExportRequest.setTitle('New Export Request');

    //clear fields
    App.txtExportRequestName.clear();
    App.txtExportRequestName.clearInvalid();

    App.btnExportRequestSave.setDisabled(true);

    //show window
    App.winExportRequest.show();
};

var showSaveAsWindow = function (request_id) {

    winExportRequestMode = 2; //Save As

    //set current request id...
    currRequestID = request_id;

    //prepare window
    App.winExportRequest.setTitle('Save As');
    App.txtExportRequestName.clear();
    App.txtExportRequestName.clearInvalid();

    App.btnExportRequestSave.setDisabled(true);

    //show window
    App.winExportRequest.show();
};

//btnSubmitReport - Submit report
var fnOnSubmitExportRequest = function () {
    var request_id = 0,
        strDF = '';

    //get current request...
    request_id = App.gpMyRequest.getSelectionModel().getSelection()[0].raw.REQUEST_ID;

    //get DataFields selected...
    strDF = fnGetDataFieldString();


    var dlg = Ext.MessageBox.show({
        title: 'Submit Data Extract Request?',
        msg: 'Would you like to submit this request?',
        buttons: Ext.MessageBox.YESNO,
        fn: function (btn) {
            switch (btn) {
                case "yes":
                    //submit...
                    App.direct.REPSSTAT.OnSubmitExportRequest(request_id, strDF, {
                        success: function () {
                            setMyRequestToolBar(1); //In Process
                        }
                    });
                    break;

                case "no":
                    /*do nothing*/
                    break;
            }
        },
        icon: Ext.MessageBox.QUESTION,
        closable: false
    });

    dlg.defaultButton = 2;

};

//btnSubmitReport - Submit report
var fnOnSubmitExportRequest2 = function () {
        
    var dlg = Ext.MessageBox.show({
        title: 'Submit Data Extract Request?',
        msg: 'Would you like to submit this request?',
        buttons: Ext.MessageBox.YESNO,
        fn: function (btn) {
            switch (btn) {
                case "yes":
                    //submit...
                    fnSubmitNewExportRequest();
                    break;

                case "no":
                    /*do nothing*/
                    break;
            }
        },
        icon: Ext.MessageBox.QUESTION,
        closable: false
    });

    dlg.defaultButton = 2;

};

var fnSubmitNewExportRequest = function () {
    var strDF = '';

    //get DataFields selected...
    strDF = fnGetDataFieldString();

    App.direct.REPSSTAT.OnSubmitNewExportRequest(strDF, {
        success: function (result) {
            if (result.submitted) {
                orgRequest = fnTakeSnapshot();
            }
            else {
                if (result.errMsg != '') {
                    App.direct.ShowSystemFeedback(result.errMsg, result.errTitle);
                }
            }
        },
        failure: GeneralErrorHandler
    });
};

/*------------------------------------------------------------------------------------------------------------------*/
/*-- MyRequest ToolBar - HELPER functions                                                                           */
/*------------------------------------------------------------------------------------------------------------------*/
var fnGetFilterString = function () {
    var strFltrs = '';
        
    //get filters...
    strFltrs += App.dfFromDate.getValue() == null ? '' : App.dfFromDate.getValue();
    strFltrs += App.dfToDate.getValue() == null ? '' : App.dfToDate.getValue();
    strFltrs += App.cboFilterRegion.getValue() == null ? '' : App.cboFilterRegion.getValue();
    strFltrs += App.cboFilterSite.getValue() == null ? '' : App.cboFilterSite.getValue();
    strFltrs += App.cboFilterProgram.getValue() == null ? '' : App.cboFilterProgram.getValue();
    strFltrs += App.chkInpatient.getValue();
    strFltrs += App.chkOutpatient.getValue();

    return strFltrs;
};

var fnGetDataFieldString = function () {
    var strDF = '',
        n = 0; //count of nodes selected
    
    //get DataFields selected...
    n = App.tDataFields.getChecked().length;
    for (i = 0; i < n; i++) {
        if (typeof (App.tDataFields.getChecked()[i].raw.field) != "undefined") {
            strDF += App.tDataFields.getChecked()[i].raw.field;
            if (i < n - 1) {
                strDF += ',';
            }
        }
    }

    return strDF;
};

var fnTakeSnapshot = function () {
    return App.tfRequestName.value + fnGetFilterString() + fnGetDataFieldString();
};
/*------------------------------------------------------------------------------------------------------------------*/
//====================================================================================================================
//== MyRequest ToolBar - END
//====================================================================================================================


//====================================================================================================================
//== MyRequest Action Column - BEGIN
//====================================================================================================================
var MyRequestPrepareCommand = function (grid, command, record, row) {
    if (command.command == 'CMD_REQUEST_CANCEL' && record.get('STATUS_CODE') != 1) {
        command.disabled = true;
    }
    if (command.command == 'CMD_REQUEST_DOWNLOAD' && record.get('STATUS_CODE') != 2) {
        command.disabled = true;
    }
};

//grid panel command handlers for buttons in the grid 
var OnMyRequestActionCommand = function (command, strStoreRow) {
    var request_id = strStoreRow.REQUEST_ID,
        report_name = strStoreRow.REPORT_NAME;

    switch (command) {
        case 'CMD_REQUEST_RENAME':
            if (!fnCheckRequestChanges(fnHandlerAnswerRenameRequest)) {
                fnOnShowRenameExportRequestWindow(request_id, report_name);
            }
            break;

        case 'CMD_REQUEST_CANCEL':
            fnOnCancelExportRequest(request_id);
            break;

        case 'CMD_REQUEST_DOWNLOAD':
            fnOnDownloadFile(request_id);
            break;
    }
};

//ACTION RENAME
var fnOnShowRenameExportRequestWindow = function (request_id, report_name) {

    winExportRequestMode = 1; //Update
    orgExportRequestName = report_name;

    //set current request id...
    currRequestID = request_id;

    //prepare window
    App.winExportRequest.setTitle('Rename');
    App.txtExportRequestName.setValue(report_name);

    App.btnExportRequestSave.setDisabled(true);

    //show window
    App.winExportRequest.show();
};

//ACTION CANCEL
var fnOnCancelExportRequest = function (request_id) {
    var dlg = Ext.MessageBox.show({
        title: 'Cancel Export Request?',
        msg: 'Would you like to cancel this request?',
        buttons: Ext.MessageBox.YESNO,
        fn: function (btn) {
            switch (btn) {
                case "yes":
                    App.direct.REPSSTAT.OnCancelExportRequest(request_id);
                    break;

                case "no":
                    /*do nothing*/
                    break;
            }
        },
        icon: Ext.MessageBox.QUESTION,
        closable: false
    });

    dlg.defaultButton = 2;
};

//ACTION DOWNLOAD
var fnOnDownloadFile = function (request_id) {
    var dlg = Ext.MessageBox.show({
        title: 'Download File?',
        msg: 'Would you like to download this file?',
        buttons: Ext.MessageBox.YESNO,
        fn: function (btn) {
            switch (btn) {
                case "yes":
                    App.direct.REPSSTAT.OnDownloadExportRequest(request_id, {
                        isUpload: true
                    });
                    break;

                case "no":
                    /*do nothing*/
                    break;
            }
        },
        icon: Ext.MessageBox.QUESTION,
        closable: false
    });

    dlg.defaultButton = 2;

};

//====================================================================================================================
//== MyRequest Action Column - END
//====================================================================================================================

//====================================================================================================================
//== CONTROL EVENTS - BEGIN
//====================================================================================================================
//tDataFields - CheckChange
var fnOnCheckChange = function (node, checked, eOpts) {
    if (node.childNodes.length > 0) {
        node.cascadeBy(function () {
            this.set('checked', checked);
        });
    }
    else {
        fnInspectDataFields();
    }

    fnBindExpandCollapse();

};

//The TreePanel loses it click event after expanding, node change, or loading a new node list.
//For this reason we need to "rebind" the event by calling the same function.
var fnBindExpandCollapse = function () {
    $('.x-tree-expander').unbind().click(function () {
        setTimeout(function () {
            fnInspectDataFields();
            fnBindExpandCollapse();
        }, 1);
    });
};

//gpMyRequest - Select
var fnOnLoadRequest = function (strStoreRow, index) {
    if (typeof (strStoreRow) == "undefined") {
        fnDisableRequestSelection();
    }
    else {
        //LOAD REQUEST
        bLoadingRequest = true; //this will prevent the Change event of the cboFilterRegion to do an async call to LoadSite
        App.direct.REPSSTAT.OnLoadExportRequest(strStoreRow.REQUEST_ID, {
            success: function () {
                bLoadingRequest = false; //loading was finish; we are free to do changes

                fnInspectDataFields();

                currMyRequestIndex = index;
                
                fnClearInvalid();
                fnSTATValForm();

                setTimeout(function () {
                    //take a snapshot of the request. This will help us idenfity if the record change
                    orgRequest = fnTakeSnapshot();
                    fnBindExpandCollapse();
                }, 1);
            },
            failure: GeneralErrorHandler
        });
    }
};

var fnInspectDataFields = function () {
    $(App.tDataFields.getRootNode().childNodes).each(function (pIdx, p) {
        var ctr = 0;

        $(p.childNodes).each(function (cInx, c) {
            if (c.data.checked) {
                ctr++;
            }
        });

        if (ctr > 0) {
            p.set('checked', true);
            if (p.childNodes.length == ctr) {
                //remove checkbox fill
                $('.x-tree-node-text:contains(' + p.data.text + ')').parent().children('.x-tree-checkbox-fill').removeClass('x-tree-checkbox-fill');
            }
            else {
                //add checkbox fill
                $('.x-tree-node-text:contains(' + p.data.text + ')').parent().children('.x-tree-checkbox-checked').addClass('x-tree-checkbox-fill');
            }
        }
        else {
            p.set('checked', false);
        }
    });
};


////gpMyRequest - Select
//var fnOnLoadRequest = function (strStoreRow, index) {
//    if (typeof (strStoreRow) == "undefined") {
//        fnDisableRequestSelection();

//        App.btnNewRequest.setDisabled(false);
//        App.btnSaveRequest.setDisabled(true);
//        App.btnSaveAsRequest.setDisabled(true);
//        App.btnSubmitReport.setDisabled(true);
//    }
//    else {
//        App.pnlFilters.setDisabled(false);
//        App.pnlDataSelection.setDisabled(false);

//        //update Toolbar
//        setMyRequestToolBar(strStoreRow.STATUS_CODE);

//        //LOAD REQUEST
//        bLoadingRequest = true; //this will prevent the Change event of the cboFilterRegion to do a async call to LoadSite
//        App.direct.REPSSTAT.OnLoadExportRequest(strStoreRow.REQUEST_ID, {
//            success: function () {
//                bLoadingRequest = false; //loading was finish; we are free to do changes

//                currMyRequestIndex = index;
//                fnClearInvalid();

//                setTimeout(function () {
//                    //take a snapshot of the request. This will help us idenfity if the record change
//                    orgRequest = fnTakeSnapshot();
//                }, 1);
//            }
//        });
//    }
//};

//gpMyRequest - BeforeSelect
var fnMyRequestBeforeSelect = function (obj, record, item, index, e, eOpts) {
    newMyRequestIndex = index;
    if (strContinueChange == "continue") {
        strContinueChange = "";
    }
    else {
        if (fnCheckRequestChanges(fnHandlerAnswerMyRequestChange)) {
            /*stop change; it will be handler on callback function (fnHandlerAnswerMyRequestChange)*/
            return false;
        }
    }
};

//gpMyRequest - FilterChange
var fnMyRequestFilterChange = function () {
    fnDisableRequestSelection();
};

//cboFilterRegion - Change
var fnOnFilterRegionChange = function (newValue) {
    if (bLoadingRequest == false)
    {
        App.direct.REPSSTAT.LoadSite(newValue);
    }
};

//cboFilterRegion - Change - clear site selection
var fnOnFilterRegionClearSel = function () {
    if (bLoadingRequest == false)
    {
        App.direct.REPSSTAT.ClearSiteSel();
    }
};

//cboFilterSite - Change
var fnOnFilterSiteChange = function (newValue) {
    if (bLoadingRequest == false) {
        if (newValue != '') {
            App.direct.REPSSTAT.LoadProgram(newValue);
        }
    }
};

/*------------------------------------------------------------------------------------------------------------------*/
/*-- CONTROL EVENT - HELPER functions                                                                               */
/*------------------------------------------------------------------------------------------------------------------*/
var setMyRequestToolBar = function (status_code) {
    switch (status_code) {
        case 0: //New
            App.btnNewRequest.setDisabled(false);
            App.btnSaveRequest.setDisabled(false);
            App.btnSaveAsRequest.setDisabled(false);
            App.btnSubmitReport.setDisabled(false);
            break;

        case 1: //In Process
        case 2: //Ready for Download
        case 3: //Canceled
            App.btnNewRequest.setDisabled(false);
            App.btnSaveRequest.setDisabled(true);
            App.btnSaveAsRequest.setDisabled(false);
            App.btnSubmitReport.setDisabled(true);
            break;
    }
};

var fnCheckRequestChanges = function (handlerAnswer) {

    //if (App.pnlFilters.disabled == false) {
        newRequest = fnTakeSnapshot();

        if (orgRequest != '') {
            if (newRequest != orgRequest) {
                Ext.MessageBox.show({
                    title: 'Submit Data Extract?',
                    msg: 'You are trying to load a previous Data Extract request and could lose your current changes.<br/>Would you like to submit your current changes as a new Data Extract request?',
                    buttons: Ext.MessageBox.YESNOCANCEL,
                    fn: handlerAnswer,
                    icon: Ext.MessageBox.QUESTION,
                    closable: false
                });

                return true;
            }
        }
    //}

    return false;
};

var fnHandlerAnswerMyRequestChange = function (btn) {
    switch (btn) {
        case "yes":
            fnSubmitNewExportRequest();
            App.gpMyRequest.getSelectionModel().deselectAll();
            ///*save changes and, if successful, go ahead*/
            //var status_code = App.gpMyRequest.getStore().getAt(currMyRequestIndex).raw.STATUS_CODE,
            //    request_id = App.gpMyRequest.getStore().getAt(currMyRequestIndex).raw.REQUEST_ID,
            //    strDF = '';

            //if (status_code == 0) { //New - We can use normal 'Save' 
            //    strContinueChange = "continue";

            //    //get DataFields selected...
            //    strDF = fnGetDataFieldString();

            //    //save/update...
            //    App.direct.REPSSTAT.OnUpdateExportRequest(request_id, strDF, true, {
            //        success: function (result) {
            //            if (result == true) {
            //                //saved, move to next...
            //                strContinueChange = "continue";
            //                App.gpMyRequest.getSelectionModel().select(newMyRequestIndex);
            //                $('div[id="gpMyRequest"] .x-grid-row-selected').click();
            //            }
            //            else {
            //                //error, stay where you are
            //                strContinueChange = "";
            //                App.gpMyRequest.getSelectionModel().select(currMyRequestIndex);
            //            }
            //        },
            //        failure: function () {
            //            //error, stay where you are
            //            App.gpMyRequest.getSelectionModel().select(currMyRequestIndex);
            //        }
            //    });
            //}
            //else {//We have to use 'Save As' 
            //    strContinueChange = "";

            //    App.gpMyRequest.getSelectionModel().select(currMyRequestIndex);
                
            //    showSaveAsWindow(request_id);
            //}
            break;

        case "no":
            /*go ahead*/
            strContinueChange = "continue";
            App.gpMyRequest.getSelectionModel().select(newMyRequestIndex);
            $('div[id="gpMyRequest"] .x-grid-row-selected').click();
            break;

        case "cancel":
            App.gpMyRequest.getSelectionModel().select(currMyRequestIndex);
            break;
    }
};

var fnHandlerAnswerRenameRequest = function (btn) {
    var status_code = App.gpMyRequest.getStore().getAt(currMyRequestIndex).raw.STATUS_CODE,
        request_id = App.gpMyRequest.getStore().getAt(currMyRequestIndex).raw.REQUEST_ID,
        report_name = App.gpMyRequest.getStore().getAt(currMyRequestIndex).raw.REPORT_NAME,
        strDF = '';

    switch (btn) {
        case "yes":
            /*save changes and, if successful, go ahead*/
            if (status_code == 0) { //New - We can use normal 'Save' 
                //get DataFields selected...
                strDF = fnGetDataFieldString();

                //save/update...
                App.direct.REPSSTAT.OnUpdateExportRequest(request_id, strDF, false, {
                    success: function (result) {
                        if (result == true) {
                            orgRequest = fnTakeSnapshot();
                            fnOnShowRenameExportRequestWindow(request_id, report_name);
                        }
                        else {
                            App.direct.ShowSystemFeedback("Unable to save changes.", "Error");
                        }
                    }
                });
            }
            else {//We have to use 'Save As' 
                showSaveAsWindow(request_id);
            }
            break;

        case "no":
            /*go ahead*/
            orgRequest = '';
            fnDisableRequestSelection();
            fnOnShowRenameExportRequestWindow(request_id, report_name);
            break;

        case "cancel":
            break;
    }
};

var fnHandlerAnswerNewRequest = function (btn) {
    var status_code = App.gpMyRequest.getStore().getAt(currMyRequestIndex).raw.STATUS_CODE,
        request_id = App.gpMyRequest.getStore().getAt(currMyRequestIndex).raw.REQUEST_ID,
        report_name = App.gpMyRequest.getStore().getAt(currMyRequestIndex).raw.REPORT_NAME,
        strDF = '';

    switch (btn) {
        case "yes":
            /*save changes and, if successful, go ahead*/
            if (status_code == 0) { //New - We can use normal 'Save' 
                //get DataFields selected...
                strDF = fnGetDataFieldString();

                //save/update...
                App.direct.REPSSTAT.OnUpdateExportRequest(request_id, strDF, false, {
                    success: function (result) {
                        if (result == true) {
                            orgRequest = fnTakeSnapshot();
                            showNewWindow();
                        }
                        else {
                            App.direct.ShowSystemFeedback("Unable to save changes.", "Error");
                        }
                    }
                });
            }
            else {//We have to use 'Save As' 
                showSaveAsWindow(request_id);
            }
            break;

        case "no":
            /*go ahead*/
            orgRequest = '';
            fnDisableRequestSelection();
            showNewWindow();
            break;

        case "cancel":
            break;
    }
};
/*------------------------------------------------------------------------------------------------------------------*/
//====================================================================================================================
//== CONTROL EVENTS - END
//====================================================================================================================
